--require( "quest/purse/convout.lua" );
require( "quest/m2_kitchendrawer/convout.lua" );
combine_speech_tables();

currentDepth = 0;
moving_actor = nil;
local video = nil;
item_upscale = 1.15;

function found_video(actor)
	actor:SetMode(MODE.CUTSCENE);
	clear_item_meshes();
	--scene:Spawn(video_spec);
	addInventory(inv_desc_vhstape);
	run_super_conversation( actor, "found_video" );	
	game:Set( "got_video", 1 );
	scene.HELP_PANEL:SetAlpha( 0 );
	help_panel_say_raw( "" );
	
	--addInventory( inv_desc_vhstape );
	
	scene.FLO:StartProc(go_back);
end

local items = 
{
	{ image = "drawer_item2",			depth = 15, 	target = false, x = 282, y = 68},
	{ image = "drawer_item3",			depth = 17,	target = false, x = 338, y = 71 },
	{ image = "drawer_item4",			depth = 12,	target = false, x = 182, y = 64 },
	{ image = "drawer_item5",			depth = 13,	target = false, x = 164, y = 120 },
	{ image = "drawer_item6",			depth = 8,	target = false, x = 336, y = 130 },
	{ image = "drawer_item7",			depth = 5,	target = false, x = 156, y = 92 },
	{ image = "drawer_item8",			depth = 3,	target = false, x = 166, y = 138 },
	{ image = "drawer_item9",			depth = 7,	target = false, x = 223, y = 163 },
	{ image = "drawer_item10",			depth = 10,	target = false, x = 201, y = 127 },	
	{ image = "drawer_item10",			depth = 2,	target = false, x = 416, y = 95 },
	{ image = "drawer_item2a",			depth = 19, 	target = false, x = 352, y = 254},
	{ image = "drawer_item4a",			depth = 16,	target = false, x = 145, y = 224 },
	{ image = "drawer_item5a",			depth = 14,	target = false, x = 173, y = 138 },
	{ image = "drawer_item6a",			depth = 9,	target = false, x = 173, y = 48 },
	{ image = "drawer_item7a",			depth = 6,	target = false, x = 413, y = 50 },
	{ image = "drawer_item8a",			depth = 4,	target = false, x = 459, y = 56 },
	{ image = "drawer_item9a",			depth = 18,	target = false, x = 281, y = 57 },
	{ image = "drawer_item10a",			depth = 11,	target = false, x = 397, y = 57 },

	{ image = "drawer_item1",	depth = 1,	target = true, x = 182, y = 191, foundProc = found_video},	
};

help_text = "help_drawer";
active_items = {};

function get_drawer_item_spec(_name, _image, _depth, _target, _x, _y, _foundProc)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
		
		command = function(actor)
			actor:SetDepthValue(_depth);
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetPointAtCursor("cursor_open_hand");
			actor.moving = false;
			actor.foundProc = _foundProc;
			actor.halo = _image;
			
			if _target then
				actor.on_click = function(flo, drawer_item)
					video = actor;
					actor:SetAlpha(0);
					actor:DumpZone();
					flo:StartProc(actor.foundProc);
					--run_super_conversation( scene.HELP_PANEL, "found_video" );	
					--actor:Expire();
					--game:Set( "got_video", 1 );
					--scene.HELP_PANEL:SetAlpha( 0 );
					--help_panel_say_raw( "" );
					--addInventory( inv_desc_vhstape );
					--scene.HELP_PANEL:SetAlpha( 1 );					
					--scene:ReturnFromScene();
					return RESPONSE.IGNORE;
				end;
			else
				actor.on_click = function(flo, drawer_item)
					--actor.hotspot = { x = 50, y = 50 };
					if ( game:Get( "got_video" ) ~= 1 ) then
						if actor.moving == false then
							local clickedAt = scene:GetClickedAtScreen();
							local actorPos = actor:GetPosition();
							actor.moving = true;
							actor.movingx = actorPos.x - clickedAt.x;
							actor.movingy = actorPos.y - clickedAt.y ;
							actor:SetDepthValue(currentDepth);
							currentDepth = currentDepth + 1;
							actor:StartProc(move_item);
							moving_actor = actor;
							actor:SetPointAtCursor("cursor_closed_hand");
							scene.GAME_CONTROLLER:StartProc(moving_item);
							sfx:PlaySFX("audio/sfx/pickup_item.ogg");
							actor:LoadZone("over_actor");
						end
					end
					return RESPONSE.IGNORE;
				end;
				
				--actor.on_release = function(flo, purse_item)
				--	actor.moving = false;
				--	return RESPONSE.IGNORE;
				--end;
				
				actor.point_at_fn = function(flo, enter)
					local scalemod = 1;
					local upscale = item_upscale;
					
					--if _data.scale then
					--	scalemod = _data.scale;
					--	upscale = upscale * scalemod;
					--end
					
					if (moving_actor == nil or actor == moving_actor) and game:Get("found_target_purse_item") == 0 then
						if enter then
							local image_size1 = actor:GetImageSize();
							image_size1.x = image_size1.x * scalemod;
							image_size1.y = image_size1.y * scalemod;
							--image_size1.x = image_size1.x * activity_data.scale;
							--image_size1.y = image_size1.y * activity_data.scale;
							actor:SetScale(upscale);
							--sfx:PlaySFX("audio/sfx/sfx_typing_03.ogg");
							local image_size2 = actor:GetImageSize();
							image_size2.x = image_size2.x * (upscale);
							image_size2.y = image_size2.y * (upscale);
							
							local newPosition = actor:GetPosition();
							newPosition.x = newPosition.x - ((image_size2.x - image_size1.x) / 2);
							newPosition.y = newPosition.y - ((image_size2.y - image_size1.y) / 2);
							actor:JumpToPoint(newPosition);
						else
							local image_size1 = actor:GetImageSize();
							image_size1.x = image_size1.x * (upscale);
							image_size1.y = image_size1.y * (upscale);
							actor:SetScale(scalemod);
							local image_size2 = actor:GetImageSize();
							image_size2.x = image_size2.x * scalemod;
							image_size2.y = image_size2.y * scalemod;
							
							local newPosition = actor:GetPosition();
							newPosition.x = newPosition.x - ((image_size2.x - image_size1.x) / 2);
							newPosition.y = newPosition.y - ((image_size2.y - image_size1.y) / 2);
							actor:JumpToPoint(newPosition);
							--sfx:PlaySFX("audio/sfx/sfx_typing_02.ogg");
						end
					end
				end;
			end
		end;
	}
end

function spawn_drawer_items(actor)
	for j,w in pairs(items) do
		local drawer_item_spec = get_drawer_item_spec(tostring(j), w.image, w.depth, w.target, w.x, w.y, w.foundProc);
		if currentDepth <= w.depth then
			currentDepth = w.depth + 1;
		end
		--table.insert(scene_spec.actorlist, purse_item_spec);
		local drawer_item = scene:Spawn(drawer_item_spec);
		if not w.target then
			table.insert(active_items, drawer_item);
		end
	end
	
	help_panel_say_raw(scene:grabstring(help_text));
end

function clear_item_meshes()
	for i,v in pairs(active_items) do
		if v then
			v:DumpZone();
		end
	end
end

game_controller_spec = 
{
	name = "GAME_CONTROLLER";
}

flo_spec =
{
	name = "FLO";

	command = function(actor)
		actor:ModifySaySpec(flo_text_spec)
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

function move_item(actor)
	while actor.moving do
		local cursorPos = scene:GetCursorPos();
		local newPoint = { x = cursorPos.x + actor.movingx, y = cursorPos.y + actor.movingy };
		newPoint.x = math.min(math.max(0, newPoint.x), 800-actor:GetImageSize().x);
		newPoint.y = math.min(math.max(0, newPoint.y), 500-actor:GetImageSize().y);
		actor:JumpToPoint(newPoint);
		coroutine.yield(RESUME.NOW);
	end
end

-- running as GAME_CONTROLLER proc whilst actor is moving
function moving_item(actor)
	coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	scene.FLO:SetMode(MODE.CUTSCENE);
	coroutine.yield(RESUME.NOW);
	
	-- if we didn't click on another clothing item, put us back
	stop_moving();
	
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
end

function stop_moving()
	-- if we didn't click on another clothing item, put us back
	if moving_actor ~= nil then
		moving_actor:LoadZone(moving_actor.halo);
		moving_actor.moving = false;
		moving_actor:SetPointAtCursor("cursor_open_hand");
		moving_actor = nil;
		sfx:PlaySFX("audio/sfx/drop_item.ogg");
	end;
end

video_spec = 
{
	name = "video";
	halo = "video";
	gfx = { image = "drawer_item1" };
	
	command = function(actor)
		actor:SetDepthValue(currentDepth);
		actor:JumpToPoint { x = 250, y = 100 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 1, b = 0 },
			y = 65,
			x = 315,
			w = 190,
			h = 260,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.TOP,
			halign = HALIGN.LEFT,
		};
		actor:SetScale(1.5);
	end;
	
--	on_click = function(flo, phone)
--		scene:ReturnFromScene();
--	end;	
};

function go_back(flo)
	scene:ReturnFromScene();
end

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/petspamusic.ogg", true);
		scene:SetCameraFollowActor(nil);
		scene:SetTextBoundsXY(20, 20);
		
		fade_scene_up(true, true);
		lower_hud();
		spawn_help_panel(true);
		
		spawn_drawer_items();
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces1",
		"pieces2",
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	ground = "background";
	
	actorlist = 
	{ 
		game_controller_spec,
		flo_spec,
		
		scene_setup,
	};
};
